#!/usr/bin/perl 
# ForensiX - a Forensic analysis program for uniX
# Copyright (c), 1985-2001 Fred Cohen
#
# port of ForensiX tcl

use Tk;
use Time::localtime;
use FileHandle;
use IO::Handle;
use lib qw(.); # add the current dir in
use FBox;

$User = getpwuid($<); # get the username for timestamping
$Installdir = '/ForensiX/';

$machinetype= "mac";
$filetype= "text";
$fstype= "hfs";
$minsize= 1;
$device= "/dev/fd0";
$cddevice ="0,1,0";
$speed =4;
$tapedevice= "/dev/st0";
$tarroot= "/ForensiX/";
$loopdev ="";
$location ="/mnt";
$verbose ="verbose";
$searchfor= "";
$searchconnect= "near";
$searchfor2= "";
$sensitive ="insensitive";
$sortby ="9";
$readonly ="ro";
$traceroptions ="-changes";
$ethernet ="eth0";
$tcplooptime= 60;
$tcploops =2;
$line = ();
# appearance variables
$mybuttonwidth = 0;
$smallbuttonwidth = 0;
$sidemenuwidth = 0;
$sidemenubuttonwidth = 0;
$relief = 'flat';
$anchor = 'n';
$padx = 8;
$pady = 0;
$comment="no comment provided";

# Command Center

sub timestamp
	{$md5 = `/ForensiX/bin/md5`;
	chop $md5; # eat the cr
	$tm = localtime;
	$year = $tm->year+1900;
	$month = $tm->mon+1;
	$day = $tm->mday;
	$time =$tm->hour.":".$tm->min.":".$tm->sec;
	return ("$year/$month/$day-$time $User $md5");}


$types= [["All files",		"*"],
	["Text files",		[".txt", ".doc"]	],
	["Graphics Files",	[".gif", ".jpeg", ".jpg"]]];

sub getfile
	{($default,$start) = @_;$thing ="";
	my $fbox =$Top->FBox( -filetypes=> $types, -initialdir=>$start);
	$thing = $fbox->Show;
	if ($thing eq "" || !defined $thing) {return $default;}
	return $thing;}

$itypes= [["Images",		[".image"]],
	["All files",		"*"]];

sub getifile
	{($default, $start) = @_;$thing =""; 
	$fbox= $Top->FBox( -filetypes=> $itypes, -initialdir=> $start);
	$thing = $fbox->Show;
	if ($thing eq "" || !defined $thing) {return $default;}
	return $thing;}

$filehandle = new FileHandle "/ForensiX/log","a+";
print $filehandle timestamp," # Enter ForensiX !\n";
$filehandle->close;

# Initial screen
$Widget = MainWindow->new;
$Widget->MainWindow->title("ForensiX 1.3a Copyright (c) Fred Cohen & Associates, 1985-2001");
# Create a frame for buttons and entry.
$Top = $Widget->Frame(-borderwidth=>1, -relief=>'raised');
$Top2 = $Widget->Frame(-borderwidth=>1, -relief=>'raised');
$Top3 = $Widget->Frame(-borderwidth=>1, -relief=>'raised');
$TextBox = $Widget->Frame( -borderwidth=>2, -relief=>'raised');
$Log = $TextBox->{'log'} = $TextBox->Scrolled("Text", -scrollbars=>'e',
	'Name','log',-width=>80,-height=>24,-borderwidth=>2,-relief=>'raised',-setgrid=>'true');
$TextBox->{'log'}->pack('-side','left',-fill=>'both',-expand=>'true');
$Top->pack($Top3,$Top2,$TextBox,'-side','top','-fill','x');

# Top menu buttons
$Top->{'.run'} = $Top->Button(Name=>'run', -text=>"Go!", -command => \&Run,
			-width =>$sidemenuwidth, -anchor=>$anchor);
$Top->{'.collect'} = $Top->Menubutton(Name =>'collect', -text,"Image",
	-menu, $Top->{'.collect'}->{'.menu'},-tearoff=> 0, -relief,$relief,
	-width,$sidemenubuttonwidth, -anchor,$anchor,-padx,$padx, -pady,$pady);
$Top->{'.mount'} = $Top->Menubutton(Name =>'mount', -text=>"Mount",
	-menu=>$Top->{'.mount'}->{'.menu'}, -tearoff=> 0, -relief=>$relief,
	-width=>$sidemenubuttonwidth, -anchor=>$anchor, -padx=>$padx, -pady=>$pady);
$Top->{'.ls'} = $Top->Menubutton(Name=>'ls', '-text',"List",
	'-menu',$Top->{'.ls'}->{'.menu'}, -tearoff=> 0, '-relief',$relief,
	'-width',$sidemenubuttonwidth, '-anchor',$anchor, '-padx',$padx, '-pady',$pady);
$Top->{'.search'} = $Top->Menubutton('Name','search','-text', "Search",'-menu',
	$Top->{'.search'}->{'.menu'}, -tearoff=>0, '-relief',$relief, '-width',$sidemenubuttonwidth,
		'-anchor',$anchor, '-padx',$padx, '-pady',$pady);
$Top->{'.dump'} = $Top->Menubutton('Name','dump','-text',"Dump",
	'-menu',$Top->{'.dump'}->{'.menu'}, -tearoff=>0, '-relief',$relief,
	'-width',$sidemenubuttonwidth, '-anchor',$anchor, '-padx',$padx, '-pady',$pady);
$Top->{'.tracer'} = $Top->Menubutton('Name','tracer','-text',"Tracer",
	'-menu',$Top->{'.tracer'}->{'.opt'}, -tearoff=>0, '-relief',$relief,
	'-width',$sidemenubuttonwidth, '-anchor',$anchor, '-padx',$padx, '-pady',$pady);
$Top->{'.jdlr'} = $Top->Menubutton('Name','jdlr','-text',"JDLR",
	'-menu',$Top->{'.jdlr'}->{'.opt'}, -tearoff=>0, '-relief',$relief,
	'-width',$sidemenubuttonwidth, '-anchor',$anchor, '-padx',$padx, '-pady',$pady);
$Top->{'.doc'} = $Top->Menubutton('Name','doc', '-text',"Document",
	'-menu',$Top->{'.doc'}->{'.menu'}, -tearoff=>0, '-relief',$relief,
	'-width',$sidemenubuttonwidth, '-anchor',$anchor, '-padx',$padx, '-pady',$pady);

$Top->{'.run'}->pack($Top->{'.collect'},$Top->{'.mount'},$Top->{'.ls'},$Top->{'.search'},$Top->{'.dump'},$Top->{'.tracer'},$Top->{'.jdlr'},$Top->{'.doc'},'-side','left');

$Top->{'.doc'}->command('-label', 'Comment', -command => \&document);
#$Widget->AddItems([ "command" =>'New Case', -command => \&newcase]);
#$Widget->AddItems([ "command" =>'New Case', -command => \&newcase]);
#$Widget->AddItems([ "command" =>'Find Case', -command => \&findcase]);
#$Widget->AddItems([ "command" =>'Work On', -command => \&workon]);

use collect; # for collect.tcl
   Top_collect_menu; # invoke it
use mount;   # for mount.tcl
   Top_mount_menu; # invoke it

#ls
$m = $Top->{'.ls'}->{'.menu'} = $Top->{'.ls'}->menu->Menu('Name','menu','-tearoff',0);
$m = $Top->{'.ls'};
$m->radiobutton('-label','quiet','-variable',\$verbose,'-command',
 sub {$command = "/ForensiX/ForensiX.listfiles $location $verbose +$sortby";});
$m->radiobutton('-label','verbose','-variable',\$verbose,'-command',
 sub {$command = "/ForensiX/ForensiX.listfiles $location $verbose +$sortby";});
$m->separator();
$m->cascade('-label',"Sort Column");
$m->entryconfigure("Sort Column",-menu=>$Top->{'.ls'}->{'.menu'}->{'.sortby'});
$m = $Top->{'.ls'}->{'.menu'}->{'.sortby'} = $Top->{'.ls'}->menu->Menu('Name','sortby','-tearoff',0);
$Top->{'.ls'}->entryconfigure("Sort Column",-menu=>$Top->{'.ls'}->{'.menu'}->{'.sortby'});
foreach $i ('none', 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
 {$m->radiobutton('-label',$i,'-variable',\$sortby,'-command',
   sub {$command = "/ForensiX/ForensiX.listfiles $location $verbose +$sortby";});}

# Search
use search;
	Top_search_menu;
use dump;
	Top_dump_menu;

# tracer
#
$m = $Top->{'.tracer'}->{'.opt'} = $Top->{'.ls'}->menu->Menu('Name','opt','-tearoff',0);
$m = $Top->{'.tracer'};
foreach   $i ('-changes','-setuids','-rhosts','-passwd','-rcfiles','-passguess','-somefile','-writeables','-chkexploit')
	{$m->radiobutton('-label',$i,'-variable',\$traceoptions, -command,
		sub {$command = "/ForesensiX/ForensiX.tracer $traceoptions";});}
$m->radiobutton('-label','WebTrace', '-variable', \$traceoptions, -command,
	sub {$command = "/ForesensiX/ForensiX.tracer $traceoptions $searchfor";});

#jdlr
#
$m = $Top->{'.jdlr'}->{'.opt'} = $Top->{'.jdlr'}->menu->Menu('Name','opt','-tearoff',0);
$m = $Top->{'.jdlr'};
$m->command('-label',"Just Doesn't Look Right!");
$m->separator;
foreach $i ("what-does-it-look-like", "what-looks-wrong", "block-by-block") {
	$m->radiobutton('-label',$i, '-variable', \$traceoptions, -command,
	sub {$command = "/ForeseniX/ForensiX.jdlr $traceoptions /mnt";});}

# Command String for middle frame
$Top3->Label(-text=>"Command:", -justify=>'left', -padx=>0)->pack(-side=>'left');
$Top3->Entry(-width=>80, -relief=>'sunken', -textvariable=>\$command)->pack();

# Search Frame
$Top2->Label(-text=>"Search for:", -justify=>'left', -padx=>0)->pack(-side=>'left');
$Search =$Top2->Entry(-width=>12, -relief=>'sunken', -textvariable=>\$Search_string)->pack(-side=>'left');
$optmenu = $Top2->Optionmenu(-options=>["near","not"], -textvariable=>\$Search_near)->pack(-side=>'left');
$Search =$Top2->Entry(-width=>12, -relief=>'sunken', -textvariable=>\$Search_string2)->pack(-side=>'left');
$optmenu = $Top2->Optionmenu(-options=>["insensitive","sensitive"], -textvariable=>\$Sensitive)->pack(-side=>'left');
$Top2->Button(Name=>'invoke', -text=>'Update Search', -width=>$sidemenuwidth,
		-relief=>'raised', -padx=>$padx, -pady=>$pady, -anchor=>$anchor, 
		-command => sub {$command = "/ForensiX/ForensiX.searchfor"." ".$filetype 
				." ".$location ." ".$verbose ." ".$minsize ." \"".$Search_string
				."\" ".$Search_near ." \"".$Search_string2 ."\" ".$Sensitive ;
						})->pack(-side=>'left');	

$Quit_button = $Top->{'.quit'} = $Top->Button('Name','quit', -text=>"Quit",
	-relief=>$relief, -width=>$sidemenubuttonwidth,	-anchor=>$anchor, -padx=>$padx,
		-pady=>$pady, -command=> \&bye);
$Quit_button = $Top->{'.help'} = $Top->Button('Name','help', -text=>"Help",
	-relief=>$relief, -width=>$sidemenubuttonwidth, -anchor=>$anchor, -padx=>$padx, -pady=>$pady,
		-command=> \&help);
$Top->{'.quit'}->pack($Top->{'.help'},'-side','right');

MainLoop;
# returns a string of date/time user and the md5 utility routine to write log entries

#execute built up command
sub Run {
	$filehandle = new FileHandle "/ForensiX/log","a+";
	print $filehandle timestamp," ",$command,"\n";
	$filehandle->close;

	$filehandle = new FileHandle "/ForensiX/output","a+";
	printf $filehandle timestamp,$command," !\n";
	$filehandle->close;
	# bash doesn't like the |& 
	#$command |& /usr/bin/tee -ai /ForensiX/output|")) 
	# bash likes redirect better 
	if ($pid =open(input,"$command 2>&1| /usr/bin/tee -ai /ForensiX/output|")) 
		{$Log->insert('end',"$command\n"); $Log->fileevent(input,'readable',\&Log);
		$Top->{'.run'}->configure(-text=>'Stop',-command=> \&Stop);}
	else	{$Log->insert('end',"$command\n");}
	close $pid;
}

sub bye {$filehandle = new FileHandle "/ForensiX/log","a+";
	print $filehandle timestamp," # Exit ForensiX !\n";$filehandle->close;
	exit;}

sub df {$command= "/ForensiX/ForensiX.docommands /bin/df /bin/mount";}
sub mount {$command ="ForensiX.mount $device $location -t$fstype -o $readonly -o loop";}
sub Doc {printf("hello from document\n");}
sub Collect {printf "Hello from Collect",@_;}
sub collect {$command = "/bin/dd if=$device of=$location/incoming";}
sub tracer {$command = "/ForensiX/ForensiX.tracer $traceroptions";}
sub df {$command= "/ForensiX/ForensiX.docommands /bin/df /bin/mount";}
sub newcase {edcase;}

sub edcase
	{$w=$Widget->Toplevel;
	$w->title("ForensiX Case Data Form");
	$w->iconname('form');
	$w->{'.msg'} = $w->Label('Name','msg','-wraplength','4i','-justify','left','-text',"Please update the entries for this case.");
	$w->{'.msg'}->pack('-side','top');
	$w->{'.buttons'} = $w->Frame('Name','buttons');
	$w->{'.buttons'}->pack('-side','bottom','-fill','x','-pady','2m');
	$w->{'.buttons'}->{'.dismiss'} = $w->{'.buttons'}->Button('Name','dismiss','-text','OK','-command',sub { $w->destroy;});
	$w->{'.buttons'}->{'.dismiss'}->pack('-side','left','-expand',1);
	foreach $i ('f1','f2','f3','f4','f5')
		{$w->{".$i"} = $w->Frame('Name',$i,'-bd',2);
		$w->{".$i"}->{'.entry'} = $w->{".$i"}->Entry('Name','entry','-relief','sunken','-width',40,'-textvariable',$i);
		$w->{".$i"}->{'.label'} = $w->{".$i"}->Label('Name','label');
		$w->{".$i"}->{'.entry'}->pack('-side','right');
		$w->{".$i"}->{'.label'}->pack('-side','left');}
	$w->{'.f1'}->{'.label'}->configure('-text',"Case Name:");
	$w->{'.f2'}->{'.label'}->configure('-text',"Case Identifier:");
	$w->{'.f3'}->{'.label'}->configure('-text',"Organization:");
	$w->{'.f4'}->{'.label'}->configure('-text',"Address:");
	$w->{'.f5'}->{'.label'}->configure('-text',"Phone:");
	$w->{'.msg'}->pack($w->{'.f1'},$w->{'.f2'},$w->{'.f3'},$w->{'.f4'},$w->{'.f5'},'-side','top','-fill','x');
	$w->bind('<Return>', sub {$w->destroy;});
	#$w->{'.f1'}->{'.entry'} = $w->{'.f1'}->Focus('Name','entry');
}

sub findcase {}
sub workon {}
sub myappend {$data = shift @_;$filehandle = new FileHandle "/ForensiX/log","a+";
	print $filehandle timestamp," ","# Document ",$data,"\n";$filehandle->close;}

sub document
	{$comment = ();	
	$w = $Widget->Toplevel;
	$w->title("Document Situation and Actions");
	$w->iconname("form");
	$w->{'.msg'} = $w->Label('Name','msg','-wraplength','4i','-justify','left','-text',"Please provide the desired documentation:");
	$w->{'.msg'}->pack('-side','top');
	$w->{'.buttons'} = $w->Frame('Name','buttons');
	$w->{'.buttons'}->pack('-side','bottom','-fill','x','-pady','2m');
	$w->{'.buttons'}->{'.dismiss'} = $w->{'.buttons'}->Button('Name','dismiss','-text','Done','-command',
		sub {myappend($comment);$w->destroy();});
	$w->{'.buttons'}->{'.dismiss'}->pack('-side','left','-expand',1);
	$w->{'.doc'} = $w->Entry('Name','doc','-relief','sunken','-width',70,'-textvariable',\$comment);
	$w->{'.doc'}->pack('-side','right');
	$w->bind('<Return>', sub {myappend($comment);$w->destroy();});
	#$w->{'.doc'} = $w->Focus('Name','doc');
	return ;
}

use help;

sub Log {if ($line = <input>)
		{$Log->insert('end',$line);$Log->see('end');}
	else	{Stop();}}

sub Stop {$Log->fileevent(input,'readable',"");close input;$Top->{'.run'}->configure(-text=>"Go",-command=>\&Run);}
