/*************************************************************************
  ACC_REC - Access 97 Password Recovery
  Written by Simple Nomad [thegnome@nmrc.org] 17Sept99
  http://www.nmrc.org/

  Compile using DJ Delorie's excellent port of the GNU compiler, whichis
  available from http://www.delorie.com/

  Thanks to Yan for pointing us to the sekrit string!

*************************************************************************/

/* includes */
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[])
	{FILE *fDatabase;
	int i;
	unsigned char recover[13];
	unsigned char password[13];
	unsigned char
	sekrit[13]={0x86,0xFB,0xEC,0x37,0x5D,0x44,0x9C,0xFA,0xC6,0x5E,0x28,0xE6,0x13};
	printf("ACC_REC - Recover the password for Microsoft Access databases\n");
	printf("Comments/bugs: thegnome@nmrc.org\n");
	printf("http://www.nmrc.org/\n");
	printf("1999 (c) Nomad Mobile Research Centre\n");
	printf("Database filename must be in 8.3 format\n\n");
	if (argc!=2)
		{printf("USAGE: acc_rec <database>\n\n");
		printf("EXAMPLES:\n");
		printf("  acc_rec secretz.mdb\n");
		exit(-1);
		}

	fDatabase=fopen(argv[1],"rb");
	if (fDatabase == NULL)
		{printf("Unable to open database file %s.\n",argv[1]);exit(1);}
	fseek(fDatabase,66,SEEK_SET);
	fread(&recover,13,1,fDatabase);
	fclose(fDatabase);
	if (!memcmp(recover,sekrit,13))
		{printf("There is no password set for database %s\n",argv[1]);exit(0);}
	for (i=0;i<13;i++) password[i]=recover[i]^sekrit[i];
	printf("The password is - ");
	for (i=0;i<13;i++) {if (isprint(password[i])) printf("%c",password[i]);}
	printf("\n");
}
