#!/usr/bin/perl

while (($name, $passwd, $uid, $etc) = getpwent) {$uid{$name} = $uid; $name{$uid} = $name;}

sub showtime
	{($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime($_[0]);
	if ($year > 50) {$year=$year+1900;} else {$year=$year+2000;}
	if ($mon < 10) {$mon="0$mon";}
	if ($mday < 10) {$mday="0$mday";}
	if ($hour < 10) {$hour="0$hour";}
	if ($min < 10) {$min="0$min";}
	if ($sec < 10) {$sec="0$sec";}
	return "$year/$mon/$mday\@$hour:$min:$sec"
	}

sub fetchdata
	{$FILE=$_[0];
	$sdev=$CONTENT{"$FILE-dev"};
	$sino=$CONTENT{"$FILE-ino"};
	$smode=$CONTENT{"$FILE-mode"};
	$snlink=$CONTENT{"$FILE-nlink"};
	$sui=$CONTENT{"$FILE-ui"};
	$suser=$CONTENT{"$FILE-user"};
	$sgi=$CONTENT{"$FILE-gi"};
	$srdev=$CONTENT{"$FILE-rdev"};
	$ssize=$CONTENT{"$FILE-size"};
	$sacctime=$CONTENT{"$FILE-acctime"};
	$smodtime=$CONTENT{"$FILE-modtime"};
	$scretime=$CONTENT{"$FILE-cretime"};
	$sbsize=$CONTENT{"$FILE-bsize"};
	$sblocks=$CONTENT{"$FILE-blocks"};
	$smd5=$CONTENT{"$FILE-md5"};
	$sdata=$CONTENT{"$FILE-data"};
	$sknown=$CONTENT{"$FILE-known"};
	$sok=$CONTENT{"$FILE-ok"};
	}

sub storedata
	{$FILE=$_[0];
	$CONTENT{"$FILE"}="t";
	$CONTENT{"$FILE-dev"}=$dev;
	$CONTENT{"$FILE-ino"}=$ino;
	$CONTENT{"$FILE-mode"}=$mode;
	$CONTENT{"$FILE-nlink"}=$nlink;
	$CONTENT{"$FILE-ui"}=$ui;
	$CONTENT{"$FILE-user"}=$user;
	$CONTENT{"$FILE-gi"}=$gi;
	$CONTENT{"$FILE-rdev"}=$rdev;
	$CONTENT{"$FILE-size"}=$size;
	$CONTENT{"$FILE-acctime"}=$acctime;
	$CONTENT{"$FILE-modtime"}=$modtime;
	$CONTENT{"$FILE-cretime"}=$cretime;
	$CONTENT{"$FILE-bsize"}=$bsize;
	$CONTENT{"$FILE-blocks"}=$blocks;
	$CONTENT{"$FILE-md5"}=$md5;
	$CONTENT{"$FILE-data"}=$data;
	$CONTENT{"$FILE-known"}=$known;
	$CONTENT{"$FILE-ok"}=$ok;
	}
sub restoredata
	{$FILE=$_[0];
	$CONTENT{"$FILE"}="t";
	$CONTENT{"$FILE-dev"}=$sdev;
	$CONTENT{"$FILE-ino"}=$sino;
	$CONTENT{"$FILE-mode"}=$smode;
	$CONTENT{"$FILE-nlink"}=$snlink;
	$CONTENT{"$FILE-ui"}=$sui;
	$CONTENT{"$FILE-user"}=$suser;
	$CONTENT{"$FILE-gi"}=$sgi;
	$CONTENT{"$FILE-rdev"}=$srdev;
	$CONTENT{"$FILE-size"}=$ssize;
	$CONTENT{"$FILE-acctime"}=$sacctime;
	$CONTENT{"$FILE-modtime"}=$smodtime;
	$CONTENT{"$FILE-cretime"}=$scretime;
	$CONTENT{"$FILE-bsize"}=$sbsize;
	$CONTENT{"$FILE-blocks"}=$sblocks;
	$CONTENT{"$FILE-md5"}=$smd5;
	$CONTENT{"$FILE-data"}=$sdata;
	$CONTENT{"$FILE-known"}=$sknown;
	$CONTENT{"$FILE-ok"}=$sok;
	}

sub checkdata
	{if ($sdev ne $dev) {print "$FILE: The Device Changed!!!\n";}
	if ($sino ne $ino) {print "$FILE: The Inode Changed!!!\n";}
	if ($smode ne $mode) {print "$FILE: The Mode Changed!!!\n";}
	if ($snlink ne $nlink) {print "$FILE: The Links Changed!!!\n";}
	if ($sui ne $ui) {print "$FILE: The UID Changed!!!\n";}
	if ($sgi ne $gi) {print "$FILE: The GID Changed!!!\n";}
# rdev tends to change across mounts
#	if ($srdev ne $rdev) {print "$FILE: The rdev Changed!!!\n";}
	if ($ssize ne $size) {print "$FILE: The Size Changed!!!\n";}
	if ($sacctime ne $acctime) {print "$FILE: The Access Time Changed!!!\n";}
	if ($smodtime ne $modtime) {print "$FILE: The Modification Time Changed!!!\n";}
	if ($scretime ne $cretime) {print "$FILE: The Creation Time Changed!!!\n";}
	if ($sblocks ne $blocks) {print "$FILE: The Number of Blocks Changed!!!\n";}
	if ($smd5 ne $md5) {print "$FILE: The MD5 Checksum Changed!!!\n";}
	if ($sdata ne $data) {print "$FILE: The First 50 Bytes Changed!!!\n";}
	}

sub showdata
	{local $FILE;
	$FILE=$_[0];
	if ($FILE ne "")
		{($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $bsize, $blocks)=stat($FILE);
		$acctime=showtime($atime); $modtime=showtime($mtime); $cretime=showtime($ctime);
		$user=$name{$ui}; $known="no"; $ok="no";
		open(File, $FILE);read(File, $data, 50);close(File);
		open(MD5H,"/ForensiX/bin/md5 -n '$FILE'|");read(MD5H,$md5,1024);close(MD5H);
		chop($md5);
		if ($verbose gt 0) {printf("%6d %12u %6o %5d %5u(%8s) %5u %6u %13u %19s %19s %19s %5u %8u %s %s\n",
			$dev, $ino, $mode, $nlink, $ui, $user, $gi, $rdev, $size, $acctime, $modtime, $cretime,
				$bsize, $blocks, $md5, $FILE);}
		if ($CONTENT{"$FILE"} eq "") {storedata($FILE);}
		else	{fetchdata($FILE);checkdata($FILE);
		}	}
	}

sub hashcheck
	{$c=0;
	foreach (keys %CONTENT)
		{$key=$_;
		if ($CONTENT{"$key"} eq "t")
			{# print "$key\n";
			fetchdata(key);	# get stored content
			$result=$HashTable{"$smd5-$ssize"};
			if ($result ne "")
				{print "\n$key matches against known file $result\n";
				$c=0;$sok="yes";$sknown="yes";restoredata($key);
				}
			else	{print ".";$c+=1;if($c >= 120) {print "\n";$c=0;}}
			}
		}
	print "\n";
	}

sub listremaining
	{
	print "Listing remaining files...\n";
	foreach (keys %CONTENT)
		{$key=$_;
		if ($CONTENT{"$key"} eq "t")
			{fetchdata($key);	# get stored content
			printf("%6d %12u %6o %5d %5u(%8s) %5u %6u %13u %19s %19s %19s %5u %8u %s %s\n",
				$sdev, $sino, $smode, $snlink, $sui, $suser, $sgi, $srdev, $ssize, $sacctime, $smodtime, $scretime,
					$sbsize, $sblocks, $smd5, $key);
			}
		}
	}

sub dbasestartup
	{if (dbmopen(%CONTENT,$dbase,undef))
		{print "Sieve database ($dbase) found and being used.\n";$new="no";}
	else	{dbmopen(%CONTENT,$dbase,0644);
		print "*** NOTICE - New sieve database ($dbase) being created.\n";$new="yes";}
	}

sub hashstartup
	{if (dbmopen(%HashTable,"/ForensiX/hashes/hashkeeper.db",undef))
		{print "Hash database being used.\n";}
	else	{print "No Hash database!!!\n"}
	}

select(STDOUT);$|=1;	# force IO on every write
$verbose=0;
$dbase=@ARGV[0];
foreach $option (@ARGV)
	{if ($option eq "+v") {$verbose+=1;print "Verbosity=$verbose\n";}
	elsif ($option eq "-v") {$verbose-=1;}
	elsif ($option eq "+all") {$all+=1;}
	elsif ($option eq "-all") {$all-=1;}
#	else {print "$option\n";}
	}
$options=@ARGV[1];
@ARGV={};
# option -c collects the data about the image mounted on the file system
# specifically, it gets the 'stat' info, the MD5 checksum, and the first 50 bytes
# it marks all files as 'new' in the sense of not being validated or seived yet.
# If the information already exists, it is tested for changes.
if ($options eq "-c")
	{print "$options: ";dbasestartup;
	while (<STDIN>) {chop; showdata($_);}
	dbmclose(%CONTENT);
	}
elsif ($options eq "-e") 	# Check against known checksums
	{print "$options: ";dbasestartup;
	hashstartup;hashcheck;
	dbmclose(%CONTENT);dbmclose(%HashTable);
	}
elsif ($options eq "-l")	# lists all of the files not yet sieved out of the process
	{print "$options:\n";dbasestartup;
	listremaining;dbmclose(%CONTENT);
	}
elsif ($options eq "-la")	# lists all of the files involved in the process.
	{print "$options: ";}
