#!/usr/bin/perl

select(STDOUT);$|=1;    # force IO on every write

@BIGNORE="";

while (($name, $passwd, $uid, $etc) = getpwent) {$uid{$name} = $uid; $name{$uid} = $name;}

printf("%6s %12s %6s %5s %5s(%8s) %5s %6s %13s %19s %19s %19s %5s %8s %32s %s\n",
	"device", "inode", "mode", "nlink", "uid", "name", "gid", "rdev", "size", "access time",
	"modification time", "creation time", "bsize", "blocks", "md5 checksum", "pathname");

sub showtime
	{($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime($_[0]);
	if ($year > 50) {$year=$year+1900;} else {$year=$year+2000;}
	if ($mon < 10) {$mon="0$mon";}
	if ($mday < 10) {$mday="0$mday";}
	if ($hour < 10) {$hour="0$hour";}
	if ($min < 10) {$min="0$min";}
	if ($sec < 10) {$sec="0$sec";}
	return "$year/$mon/$mday\@$hour:$min:$sec"
	}

sub showdata
	{local $FILE;
	$FILE=$_[0];
	($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $bsize, $blocks)=stat("$FILE");
	$acctime=showtime($atime);	$modtime=showtime($mtime);	$cretime=showtime($ctime);
	$user=$name{$ui};
	open(MD5H,"/ForensiX/bin/md5 '$FILE'|");read(MD5H,$md5,1024);close(MD5H);
	($prog, $filename, $equal, $md) = split(/\s+/,$md5);
	printf("%6d %12u %6o %5d %5u(%8s) %5u %6u %13u %19s %19s %19s %5u %8u %s %s\n",
		$dev, $ino, $mode, $nlink, $ui, $user, $gi, $rdev, $size, $acctime, $modtime, $cretime, $bsize, $blocks, $md, $FILE);
	$BIGNORE{"$FILE"}="X";
	}
	
sub lister
	{local $FILE;
	print "$FILE\n";
	$FILE=pop @DIRS;
	if ($BIGNORE{"$FILE"} ne "X")
		{$BIGNORE{"$FILE"}="X";
		if (-d $FILE)
			{showdata($FILE);
			opendir(HANDLE,$FILE);
			@ZZ=readdir(HANDLE);
			closedir(HANDLE);
			foreach $L (@ZZ) {if (-l "$FILE/$L") {showdata("$FILE/$L");}
					elsif (!-d "$FILE/$L") {showdata("$FILE/$L");}
					elsif (-d "$FILE/$L") {if (($L ne ".") && ($L ne "..")) {push(@DIRS, "$FILE/$L");}}}
#			foreach $L (@ZZ) {if (-d "$FILE/$L") {if (($L ne ".") && ($L ne "..")) {push(@DIRS, "$FILE/$L");}}}
			}
		}
	}

push(@DIRS, @ARGV[0]);
while ((length(@DIRS) > 0) && (@DIRS[0] ne "")) {lister();}
