#!/usr/bin/perl

select(STDOUT);$|=1;    # force IO on every write

while (($name, $passwd, $uid, $etc) = getpwent) {$uid{$name} = $uid; $name{$uid} = $name;}

sub showtime
	{($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = gmtime($_[0]);
	if ($year > 50) {$year=$year+1900;} else {$year=$year+2000;}
	if ($mon < 10) {$mon="0$mon";}
	if ($mday < 10) {$mday="0$mday";}
	if ($hour < 10) {$hour="0$hour";}
	if ($min < 10) {$min="0$min";}
	if ($sec < 10) {$sec="0$sec";}
	return "$year/$mon/$mday\@$hour:$min:$sec"
	}

sub showdata
	{local $FILE;
	$FILE=$_[0];
	($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $bsize, $blocks)=stat($FILE);
	$acctime=showtime($atime);	$modtime=showtime($mtime);	$cretime=showtime($ctime);
	$user=$name{$ui};
	open(MD5H,"/ForensiX/bin/md5 -n '$FILE'|");read(MD5H,$md5,1024);close(MD5H);
	chop($md5);
	printf("%6d %12u %6o %5d %5u(%8s) %5u %6u %13u %19s %19s %19s %5u %8u %s %s\n",
		$dev, $ino, $mode, $nlink, $ui, $user, $gi, $rdev, $size, $acctime, $modtime, $cretime, $bsize, $blocks, $md5, $FILE);
	}

while (<>) {chop; showdata($_);}
