#
# replacement for mount.tcl
#

sub Top_mount_menu {
$m=$Top->{'.mount'}->{'.menu'} = $Top->{'.mount'}->menu->Menu('Name','.menu','-tearoff',0);;
$m = $Top->{'.mount'};
$m->command(-label,"List mounts",'-command', sub {
		df()
		}
);
$m->command(-label,"Dismount",'-command',
 sub
  {
   $command = "/ForensiX/ForensiX.dismount /mnt";
  }
);
$m->command(-label,"Analyze disk/image",'-command',
 sub
  {
   $device = getifile($device,'/ForensiX/images');
   $command = "/ForensiX/bin/pd -m -d $device;/ForensiX/bin/pd -e -d $device;";
  }
);
$m->command('-label',"Mount disk image",'-command',
 sub
  {
   $device = getifile($device,'/ForensiX/images');
   $loopdev = "-o loop";
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$m->cascade('-label',"Mount Device");
$menu->{'.device'} =$Top->{'.mount'}->{'.device'}= $Top->{'.mount'}->menu->Menu('Name','device','-tearoff',0);
$m->entryconfigure("Mount Device", -menu=>$menu->{'.device'});
$m = $menu->{'.device'};
foreach $i ('/dev/cdrom', '/dev/fd0', '/dev/hd0', '/dev/hd0a', '/dev/fd1', '/dev/hde')
 {
  $m->radiobutton('-label',$i,'-variable',\$device,'-command',
   sub
    {
     $loopdev = "";
     $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
    }
  );
 }
$m->command('-label',"Other device",'-command',
 sub
  {
   $device = getfile($device,'/dev');
   $loopdev = "";
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$Top->{'.mount'}->cascade('-label',"Mount OStype");
$m = $menu->{'.ostype'} = $Top->{'.mount'}->{'.ostype'} = $Top->{'.mount'}->Menu('Name','ostype','-tearoff',0);
$Top->{'.mount'}->entryconfigure("Mount OStype",-menu=>$menu->{'.ostype'});

$m->radiobutton('-label','mac','-variable',\$machinetype,'-command',
 sub
  {
   $fstype = 'hfs';
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$m->radiobutton('-label','dos','-variable',\$machinetype,'-command',
 sub
  {
   $fstype = 'msdos';
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$m->radiobutton('-label','win','-variable',\$machinetype,'-command',
 sub
  {
   $fstype = 'vfat';
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$m->radiobutton('-label','unix','-variable',\$machinetype,'-command',
 sub
  {
   $fstype = 'ext2';
   $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
  }
);
$m->cascade('-label',"Other file system");
$m2 = $m->{'.fstype'} = $m->Menu('Name','fstype','-tearoff',0);
$m->entryconfigure("Other file system",'-menu',$m->{'.fstype'});
foreach $i ('auto','adfs', 'affs', 'autofs', 'coda', 'coherent', 'devpts', 'ext', 'ext2', 'fat', 'fat16', 'fat32', 'file', 'hfs', 'hpfs', 'iso9660', 'minix', 'msdos', 'ncp', 'ncpfs', 'nfs', 'ntfs', 'proc', 'qnx4', 'romfs', 'smbfs', 'sysv', 'ufs', 'umsdos', 'vfat', 'xenix', 'xiafs')
 {
  $m2->radiobutton('-label',$i,'-variable',\$fstype,'-command',
   sub
    {
     $command = "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev";
    }
  );
 }
};
1;
