
set m [menu .top.mount.menu -tearoff 0]
$m add command -label "List mounts" -command df
$m add command -label "Dismount" -command {set command "/ForensiX/ForensiX.dismount /mnt"}
$m add command -label "Analyze disk/image" -command { set device [getifile $device /ForensiX/images] ; set command "/ForensiX/bin/pd -m -d $device;/ForensiX/bin/pd -e -d $device;"}
$m add command -label "Mount disk image" -command { set device [getifile $device /ForensiX/images] ; set loopdev "-o loop" ; set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
$m add cascade -label "Mount device" -menu $m.device
$m add cascade -label "Mount OStype" -menu $m.ostype

set m [menu .top.mount.menu.device -tearoff 0]
foreach i {/dev/cdrom /dev/fd0 /dev/hd0 /dev/hd0a /dev/fd1 /dev/hde} {
	$m add radio -label $i -variable device -command {
	set loopdev "";	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
	}
$m add command -label "Other device" -command { set device [getfile $device /dev] ; set loopdev "" ; set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}

set m [menu .top.mount.menu.ostype -tearoff 0]
$m add radio -label mac -variable machinetype -command {set fstype hfs;
	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
$m add radio -label dos -variable machinetype -command {set fstype msdos
	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
$m add radio -label win -variable machinetype -command {set fstype vfat
	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
$m add radio -label unix -variable machinetype -command {set fstype ext2
	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
$m add cascade -label "Other file system" -menu $m.fstype
set m2 [menu $m.fstype -tearoff 0]
foreach i {auto adfs affs autofs coda coherent devpts ext ext2 fat fat16 fat32 file hfs hpfs iso9660 minix msdos ncp ncpfs nfs ntfs proc qnx4 romfs smbfs sysv ufs umsdos vfat xenix xiafs} {
	$m2 add radio -label $i -variable fstype -command {
	set command "ForensiX.mount $device /mnt -t$fstype -o $readonly $loopdev"}
	}

