sub audsort
{($void, $void, $date1, $time1, $void)=split(/\s+/, $a, 5);
($void, $void, $date2, $time2, $void)=split(/\s+/, $b, 5);
"$date1$time1" cmp "$date2$time2";}

sub crossmatch
{print $SECSTART;print "Crossmatching audit files.\n";
print " In the following analysis, organizational policy dictates how to respond
 to the indicated items.  Refer to your standards and procedures manuals for
 details on proper response, or contact your incident response team for detailed
 analysis of these indications.\n\n";

$SYSLOG="/u/logs/sys/syslog.9605";
print "Reformatting $SYSLOG to standard.\n";
unlink($LOGSYSFILE);
open(SYSLOG,"$SYSLOG");
select(SYSLOG);$|=1;
open(OUT, ">>$LOGSYSFILE");
select(OUT);$|=1;
select(STDERR);$|=1;select(STDOUT);$|=1;
%MtoN=("Jan", "01", "Feb", "02", "Mar", "03", "Apr", "04", "May", "05", "Jun", "06",
"Jul", "07", "Aug", "08", "Sep", "09", "Oct", "10", "Nov", "11", "Dec", "12");
$count=0;$tcount=0;
while (<SYSLOG>)
	{chop;$LINE=$_;$ignore=0;
	local($month, $day, $time, $host, $thing, $mess, $age) = split(/\s+/,$LINE,7);
	local($serv, $pid, $void) = split(/[\[\]]/,$thing,3);
        $remuser="unknown";
	if ($month ne "ManAlMail")
		{$mon=$MtoN{"$month"};$date="1996/$mon/$day";
		if (length($day) != 2) {$date="1996/$mon/0$day";}
		$remuser="unknown";
		if ($day eq "") {$ignore=1;}
	}
	if ($month eq "ManAlMail")
		{($serv, $void, $month, $day, $time, $void, $year, $host, $pid, $remhost, $remuser, $mess, $age) = split(/\s+/,$LINE,13);
		$mon=$MtoN{"$month"};$date="$year/$mon/$day";
		if (length($day) != 2) {$date="$year/$mon/0$day";}
		$serv="ManAlMail";
		if ($mess eq "incoming:") {$ignore=1;}}
	elsif ($mess eq "warning:") {$ignore=1;}
	elsif ($mess eq "connect") {($void, $remhost) = split(/\s+/,$age,2);}
	elsif ($mess eq "refused") {($void, $void, $remhost) = split(/\s+/,$age,3);
		$where=index($remhost,"@");
		if ($where > -1) {($remuser, $remhost) = split(/\@/,$remhost);}}
	elsif ($serv eq "in.identd") {($void, $remhost) = split(/\s+/,$age);$ignore=1;}
	elsif ($serv eq "sendmail") {$ignore=1;}
	elsif ($serv eq "in.telnetd")
		{if ($mess eq "twist")
			{($remhost, $void) = split(/\s+/,$age,2);
			$where=index($remhost,"@");
			if ($where > -1) {($remuser, $remhost) = split(/\@/,$remhost);}}
		elsif ($mess eq "refused")
			{($void, $void, $remhost) = split(/\s+/,$age,3);
			$where=index($remhost,"@");
			if ($where > -1) {($remuser, $remhost) = split(/\@/,$remhost);}}
		else {($void, $void, $remhost) = split(/\s+/,$age,3);}
			$where=index($remhost,"@");
			if ($where > -1) {($remuser, $remhost) = split(/\@/,$remhost);}}
	elsif ($serv eq "in.thttpd") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.httpexec") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.ftpd") {($void,  $void, $remhost) = split(/\s+/,$age,3);
                if ($mess eq twist) {($remhost, $void, $void, $remip, $serv, $remuser, $remhost, $void) = split(/\s+/,$age,8);}
                }
	elsif ($serv eq "in.fingerd") {($void, $remhost) = split(/\s+/,$age,2);}
	elsif ($serv eq "in.rlogind") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.rshd") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.gopherd") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.gopherd2") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.redirect") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "in.readonly") {($void, $void, $void, $remhost, $remuser) = split(/\s+/,$age, 5);}
	elsif ($serv eq "vmunix:") {$ignore=1;}
	elsif ($serv eq "savecore:") {$ignore=1;}
	else {$remhost="Unknown-service-request";}
	$remhost=~tr/[A-Z]/[a-z]/; $remuser=~tr/[A-Z]/[a-z]/;
	$RevHost = reverse($remhost);
	if ($ignore==0) {print OUT "$RevHost $remhost $remuser $date $time $serv $pid $host $mess $age\n";}
	$count=$count+1;$tcount=$tcount+1;
	if ($count > 999) {close(OUT);open(OUT, ">>$LOGSYSFILE");$count = 0;print "$tcount lines\r";}
	}
close(SYSLOG);
$WEBLOG="/u/logs/www/wwwlog.9605";
print "\nReformatting $WEBLOG to standard.\n";
open(WEBLOG, "$WEBLOG");
while (<WEBLOG>)
	{chop;$LINE=$_;
	($remhost, $remuser, $date, $time, $pid, $ppid, $mess, $age) = split(/\s+/, $LINE, 8);
	$remhost=~tr/[A-Z]/[a-z]/; $remuser=~tr/[A-Z]/[a-z]/;
	$RevHost = reverse($remhost);
	if ($remuser ne "")
		{print OUT "$RevHost $remhost $remuser $date $time thttpd $ppid all $mess $age\n";}
	$count=$count+1;$tcount=$tcount+1;
	if ($count > 999) {close(OUT);system("sync");open(OUT, ">>$LOGSYSFILE");
				$count = 0;print "$tcount lines\r";}
	}
close(WEBLOG);
$GOPHERLOG="/u/logs/gopher/gopherlog.9605";
print "\nReformatting $GOPHERLOG to standard.\n";
open(GOPHERLOG, "$GOPHERLOG");
while (<GOPHERLOG>)
	{chop;$LINE=$_;
	($remhost, $remuser, $date, $time, $pid, $ppid, $mess, $age) = split(/\s+/, $LINE, 8);
	$remhost=~tr/[A-Z]/[a-z]/; $remuser=~tr/[A-Z]/[a-z]/;
	$RevHost = reverse($remhost);
	if ($remuser ne "")
		{print OUT "$RevHost $remhost $remuser $date $time thttpd $ppid all $mess $age\n";}
	$count=$count+1;$tcount=$tcount+1;
	if ($count > 999) {close(OUT);system("sync");open(OUT, ">>$LOGSYSFILE");
			$count = 0;print "$tcount lines\r";}
	}
close(GOPHERLOG);close(OUT);
print "$tcount total lines in $LOGSYSFILE\n";
print "Sorting combined logfile\n";
system("sort -f $LOGSYSFILE > $LOGSYSFILE.tmp");
system("mv $LOGSYSFILE.tmp $LOGSYSFILE");
print "Analyzing combined and sorted log file\n";
open(LOGSYSFILE, "$LOGSYSFILE");open(OUT, ">$LOGSYSFILE.tmp");
%IGNOREHOST=("all.net", "X", "unix", "X");
%IGNORESERV=("in.fingerd", "X", "in.identd", "X", "sendmail", "X", "httpexec", "X",
	"readonly", "X", "in.readonly", "X", "thttpd", "X", "in.thttpd", "X",
	"in.gopherd", "X", "in.httpexec", "X", "in.redirect", "X", "in.gopherd2", "X");
$HostThreshold=2;$NetThreshold=6;
$start=1;$total=0;$ignorecount=0;
$Btot=0;$Ctot=0;
while (<LOGSYSFILE>)
 {chop;$LINE=$_;
 ($RevHost, $remhost, $remuser, $date, $time, $serv, $pid, $host, $mess, $age)=split(/\s+/, $LINE,9);
 ($void, $pushline) = split(/\s+/, $LINE,2);
 ($a, $b, $c)=split(/\./, $RevHost,3);
 if ($start == 1) {$counta=0;$countb=0;$countc=0;$start=0;
	$olda=$a;$oldb=$b;$oldc=$c;$oldhost=$remhost;($void, $oldnet)=split(/\./,$remhost,2);}
 if (($IGNOREHOST{"$remhost"} eq "X")  || ($IGNORESERV{"$serv"} eq "X"))
 	{$ignoring=1;$pushline=".$pushline";$ignorecount=$ignorecount+1;}
 else {$pushline="*$pushline";$total=$total+1;}
 if ($a ne $olda)
 	{if ($countc > $HostThreshold)
 		{print OUT "\n*** Host $oldhost has exceeded detection threshold: ";
 		print OUT "host total = $countc\n"; $Ctot=$Ctot+1;
 		foreach $line (sort audsort @hostlist) {print OUT "$line\n";pop(@netlist);}
 		@hostlist=();}
 	if ($countb > $NetThreshold)
 		{print OUT "\n*** Network $oldnet has exceeded detection threshold: ";
 		print OUT "net total = $countb\n";$Btot=$Btot+1;
 		foreach $line (sort audsort @netlist) {print OUT "$line\n";}
 		@hostlist=();@netlist=();}
 	$counta=0;$countb=0;$countc=0;$olda=$a;$oldb=$b;$oldc=$c;
 	@hostlist=();@netlist=();}
 elsif ($b ne $oldb)
 	{if ($countc > $HostThreshold)
 		{print OUT "\n*** Host $oldhost has exceeded detection threshold: ";
		print OUT "host total = $countc\n";$Ctot=$Ctot+1;
 		foreach $line (sort audsort @hostlist) {print OUT "$line\n";pop(@netlist);}
 		@hostlist=();}
 	if ($countb > $NetThreshold)
 		{print OUT "\n*** Network $oldnet has exceeded detection threshold: ";
		print OUT "net total = $countb\n";$Btot=$Btot+1;
 		foreach $line (sort audsort @netlist) {print OUT "$line\n";}
 		@hostlist=();@netlist=();}
 	$countc=0;$countb=0;$oldc=$c;$oldb=$b;
 	@hostlist=();@netlist=();}
 elsif ($c ne $oldc)
 	{if ($countc > $HostThreshold)
 		{print OUT "\n*** Host $oldhost has exceeded detection threshold: ";
		print OUT "host total = $countc\n";$Ctot=$Ctot+1;
 		foreach $line (sort audsort @hostlist) {print OUT "$line\n";pop(@netlist);}
 		@hostlist=();}
 	$countc=0;$oldc=$c;@hostlist=();}
 if ($ignoring == 0) {$countc=$countc+1;$countb=$countb+1;$counta=$counta+1;}
 $ignoring=0;
 push(@hostlist,$pushline);push(@netlist,$pushline);
 $oldhost=$remhost;($void, $oldnet)=split(/\./,$remhost,2);
# print OUT "$remhost $remuser $date $time $serv $pid $host $mess $age\n";
 }
print OUT "Total records = ", $ignorecount+$total, " ignored $ignorecount and used $total (", 100*$total/($ignorecount+$total), "%)\n";
print "Total records = ", $ignorecount+$total, " ignored $ignorecount and used $total (", 100*$total/($ignorecount+$total), "%)\n";
print OUT "Total class C = $Btot - Total hosts = $Ctot\n";
print "Total class C = $Btot - Total hosts = $Ctot\n";
close(OUT);close(LOGSYSFILE);
system("mv $LOGSYSFILE.tmp $LOGSYSFILE.out");
print $SECEND;print "Done crossmatching audit files.\n\n\n";
}

return true;
