sub hostequiv
{print $SECSTART;print "Checking $HOSTSEQUIV file.\n";
if (-e $HOSTSEQUIV)
	{print "You have an $HOSTSEQUIV file.  This may permit users on\n";
	print "other systems to enter your system without a password and\n";
	print "alter your files without authentication.  Here is the file:\n\n";
	@tmp=split(/\n/, `$CATPROG $HOSTSEQUIV`);@HEFILE=grep(!/^#/,@tmp);
	if (scalar(@HEFILE) != 0)
		{foreach $L (@HEFILE) {print "$L\n";}
		print "Check this very carefully and remove any inappropriate lines\n";
		print "Consider the fact that outside attackers may forge IP addresses\n";
		print "to exploit this and make certain you are doing the right thing.\n\n";}
 	if (scalar(@HEFILE) > 3) {print "Over 3 hosts should almost never be trusted in $HOSTSEQUIV.\n";}
	else	{print "At least you have a limited number of trusted hosts.\n";}
	@ZZ=grep(/^\+$/, @HEFILE);
	if (scalar(@ZZ) != 0)
		{print "**** EXTREMELY DANGEROUS CONDITION FOUND *****\n";
		print "Your $HOSTSEQUIV file has the following line(s) with only '+':\n";
		foreach $L (@ZZ) {print "$L\n";}
		print "These lines may allow anyone to access your systems - please remove them.\n\n";}
	@ZZ=grep(/^\-.*/, @HEFILE);
	if (scalar(@ZZ) != 0)
		{print "**** EXTREMELY DANGEROUS CONDITION FOUND *****\n";
		print "Your $HOSTSEQUIV file has the following lines starting with '-':\n";
		foreach $L (@ZZ) {print "$L\n";}
		print "These may allow anyone to access your systems - please remove them.\n\n";}
	if (scalar(@HEFILE) != 0)
		{print "----- NOTICE\n";
		print "Please verify that only fully qualified hostnames are used.\n";
		print "Use netgroups for easier management if you run NIS [YP].\n";
		print "Reverify it after each patch or operating system change.\n";
		print "Check this periodically.\n\n";
	}	}
else	{print "No $HOSTSEQUIV file found.\n";}
print $SECEND;print "Done checking $HOSTSEQUIV.\n\n\n";
}
return true;

