sub nfsholes
{print $SECSTART;print "Checking for NFS holes.\n";
@ZZ=split(/\n/,`$PSPROG $PSOPTS`);
@tmp=grep(/.*$NFSD.*/, @ZZ);
@ZZ=grep(!/^#/, @tmp);
if (scalar(@ZZ) != 0)
	{print "You appear to be running the NFS daemon.\n";
	print "Disable NFS if you do not need it by removing the NFS startup\n";
	print "commands from /etc/rc* or other system-dependent files\n";
	print "or comment them out by adding a '#' to the beginning of the lines.\n";
	print "I think they currently look like this:\n";
	foreach $RCFILE (@RCFILES)
		{@tmp=split(/\n/,`$GREPPROG $NFSD $RCFILE`);
		@RCSTUF=grep (!/^#/,@tmp);
		foreach $L (@RCSTUF) {print "	$L\n";}}
	print "\nIf you MUST run NFS, the following suggestions are given:\n";
	print "If you have a router, filter NFS traffic by preventing TCP and UDP\n";
	print "traffic on ports 111 and 2049. This will prevent machines not on\n";
	print "your subnet from accessing file systems exported by your machines.\n";
	print "See your router manual for details on how to do this.\n";
	print "Enable NFS port monitoring so that calls to mount a file system\n";
	print "will only be accepted from ports above 1024.  Check your vendor's\n";
	print "documentation to see if this is an option for your version of Unix.\n\n";
	$NFS="yes";}
else	{print "Your system is not apparently running the NFS daemon at this time.\n\n";
	$NFS="no";}
if (-e $EXPORTS)
	{@tmp=split(/\n/,`$CATPROG $EXPORTS`);@RCSTUF=grep(!/^#/,@tmp);
	if (scalar(@RCSTUF) > 0)
		{print "Your NFS daemon will currently export file systems as follows:\n";
		foreach $L (@RCSTUF) {print "	$L\n";} print "\n";
		print "Verify that this is correct.  Remember that remote access to your\n";
		print "NFS mounted file systems can be attained by packet forgery\n";
		print "and be certain that you provide other protection to prevent that\n";
		print "eventuality.  If it should be changed, edit the $EXPORTS\n";
		print "file to correct the situation.\n\n";}
	@tmp=grep(/.*local.*/,@RCSTUF);@RCSTUF=grep(!/^#/,@tmp);
	if (scalar(@RCSTUF) > 0)
		{print "***** DANGER - NFS to local domains as indicated below is unsafe:\n";
		foreach $L (@RCSTUF) {print "	$L\n";} print "\n";}
	@tmp=split(/\n/,`$CATPROG $EXPORTS`);@RCSTUF=grep(!/^#/,@tmp);
	@ZZ=grep(!/\-access/, @RCSTUF);
	if (scalar(@ZZ) > 0)
		{print "The following lines may allow access from machines outside of\n";
		print "your local domain.  This should not be allowed if at all avoidable.\n";
		print "To correct this, edit these lines out of the $EXPORTS file.\n";
		foreach $L (@ZZ) {print "	$L\n";}
		print "\n";}
	@ZZ=grep(/rw/, @RCSTUF);
        if (scalar(@ZZ) > 0)
		{print "The following lines indicate file systems that are\n";
		print "writable by users on other machines.  Note that any other\n";
		print "machine that can reach this network can potentially write\n";
		print "into any part of this file system.  If this is not desired,\n";
		print "edit these lines in the $EXPORTS file to change rw to r.\n";
		foreach $L (@ZZ) {print "	$L\n";}
		print "\n";}
	if ($NFS eq "yes")
		{print "Changes in $EXPORTS will only take effect after\n";
		print "you run /usr/etc/exportfs as root.\n\n";
		print "The following list itemizes currently exported file systems.\n";
		print "Please verify that this is correct and corresponds to your\n";
		print "expectations.  If it is not correct, check the $EXPORTS\n";
		print "file, and if this does not show problems, contact your vendor.\n";
		@ZZ=split(/\n/,`$SHOWMOUNTPROG -e`);
		foreach $L (@ZZ) {print "	$L\n";}
		print "\n";}
	print "If you plan on exporting file systems with NFS, some increased protection\n";
	print "can be provided by running 'fsrand' on the exported file systems and\n";
	print "using the 'secure' NFS option if available.  Check vendor documentation\n";
	print "for further details.\n\n";
	permcheck($EXPORTS,0,"root");
	}
print $SECEND; print "Done checking for NFS holes.\n\n\n";
}
return true;
