sub rhosts
{print $SECSTART;print "Checking for .rhosts and .netrc files.\n";
if (-e "/.rhosts")
	{print "**** EXTREMELY DANGEROUS CONDITION FOUND *****\n";
	print "Root directory has an .rhosts file.\n";
	print "Remove this file by typing 'rm -f /.rhosts' as root.\n";
	print "At most, such a file should only exist during a remote\n";
	print "backup or other maintenance operation and should only be in place\n";
	print "for a few seconds as the remote access is started.\n";
	print "Either an administrator has created the .rhosts file to allow\n";
	print "remote entry from another host without a password, or\n";
	print "an attacker has planted the file for future entry.\n\n";}
if (-e "/.netrc")
	{print "++++ Potentially dangerous condition found ++++\n";
	print "Root directory has an .netrc file.\n";
	print "Remove this file by typing 'rm -f /.netrc' as root.\n";
	print "At most, such a file should only exist during a remote\n";
	print "backup or other maintenance operation and should only be in place\n";
	print "for a few seconds as the remote access is started.\n";
	print "Either an administrator has created the .netrc file to allow\n";
	print "remote entry from another host without a normal password, or\n";
	print "an attacker has planted the file for future entry.\n\n";}
@PFILE=split(/\n/,`$CATPROG $PASSWD`);
foreach $LINE (@PFILE)
	{($user, $pwd, $uid, $gid, $name, $home, $shell)=split(/:/, $LINE);
	if (-e "$home/.rhosts")
		{print "++++ WARNING Found .rhosts file in $home\n";
		print "Verify the propriety of this file with $user [$name].\n";
		print "Either the user has created an .rhosts file to allow\n";
		print "remote entry from another host without a password, or\n";
		print "an attacker has planted the file for future entry.\n";
		($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat("$home/.rhosts");
		if ($size > 10000) {print "++++ CAUTION - $home/.rhosts is VERY large - please examine it\n";}
		permcheck("$home/.rhosts",$uid,"$user");
		@RHFILE=split(/\n/,`$CATPROG $home/.rhosts`);
		if ('-' eq substr(@RHFILE[0],0,1)) {print "**** DANGER - the first character of the $home/.rhosts for $uid [$user] should NOT be a '-'\n";}
		if (grep(/.*\+.*/,@RHFILE))
			{print "**** DANGER - the character '+' should be removed from the $home/.rhosts for $uid [$user].\n";}
		print "\n";}
	if (-e "$home/.netrc")
		{print "++++ Warning Found .netrc file in $home.\n";
		print "Verify the propriety of this file with $user [$name].\n";
		print "Either the user has created a .netrc file to allow\n";
		print "remote entry from another host without a password, or\n";
		print "an attacker has planted the file for future entry.\n";
		($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat("$home/.netrc");
		if ($size > 10000) {print "++++ CAUTION - $home/.netrc is VERY large - please examine it\n";}
		permcheck("$home/.netrc",$uid,"$user");
		@RHFILE=split(/\n/,`$CATPROG $home/.netrc`);
		if ('-' eq substr(@RHFILE[0],0,1)) {print "**** DANGER - the first character of the $home/.netrc for $uid [$user] should NOT be a '-'\n";}
		if (grep(/.*\+.*/,@RHFILE))
			{print "**** DANGER - the character '+' should be removed from the $home/.netrc for $uid [$user].\n";}
		print "\n";}
	}
print $SECEND; print "Done checking for .rhosts and .netrc files.\n\n\n";
}
return true;

