sub setuids
{print $SECSTART; print "Checking for SetUID and SetGID files.\n";
@setuids=split(/\n/,`$FINDPROG / -type f \\\( -perm -004000 -o -perm -002000 \\\) -exec $LSPROG \{\} \\\; 2>/dev/null`);
if (scalar(@setuids) != 0)
	{print "The following files are SetUID or SetGID.  Files should only be\n";
	print "protected this way if they are designed to allow unlimited access\n";
	print "to the owner's files or if they are specially designed to be secure.\n\n";
	foreach $L (@setuids)
		{print "$L\n";
		($prot, $links, $uid, $gid, $size, $month, $day, $time, $name) = split(/\s+/, $L);
		if ($links > 1) {print "  *** Multiple links for SetUID files are usually inappropriate.\n      Please remove inappropriate links using the 'unlink' command.\n\n"}
		@M=grep(/$name/,@BADSUIDS);
		if (scalar(@M) != 0)
			{print "  *** Some versions of $name are known to be flawed SetUID programs.\n     Please check with your vendor to assure that these versions are safe.\n\n";}
		if ($uid eq "root")
			{$found="no";
			while (($M, $OWNER) = each %CRITDIRS)
				{if (scalar(grep(/^$M.+/, $name)) != 0) {$found="yes";}}
			if ($found eq "no") {print "  *** DANGER - $name is SetUID to root and not in a system directory.\n";
				print "     Investigate and remove $name using\n     'rm $name' unless this exception is appropriate.\n";
				print "     If this exception is appropriate, please update the exception list to eliminate future warnings.\n\n";}
			}
		}
	}
print $SECEND;print "Done checking for SetUID and SetGID files.\n\n\n";
}

return 1;
