sub permcheck	# takes file, owner ID, owner name as args
	{local ($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat($_[0]);
	if ($ui != $_[1]) {print "***** Danger - $_[0] should be owned by user $_[2].\n   Use 'chown $_[2] $_[0]' as root to correct this.\n\n";}
	if ($nlink != 1) {print "***** Danger - $_[0] should NOT be linked to other files.\n   Use 'unlink' to unlink other names from it.\n\n";}
	if ((022 & $mode) != 00) {print "***** Danger - $_[0] should ONLY be writable by its owner ($_[2]).\n   Use 'chmod g-w $_[0]' to repair this.\n\n";}
	}
sub permcheckx	# takes file, owner ID, owner name, and expected permision as args
	{local ($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat($_[0]);
	if ($ui != $_[1]) {print "***** Danger - $_[0] should be owned by user $_[2].\n   Use 'chown $_[2] $_[0]' as root to correct this.\n\n";}
	if ($nlink != 1) {print "***** Danger - $_[0] should NOT be linked to other files.\n   Use 'unlink' to unlink other files from $_[0].\n\n";}
	if ((03777 & $mode) != $_[3]) {print "***** Danger - $_[0] should be protected $_[4].\n   Use 'chmod $_[4] $_[0]' as root to fix this.\n\n";}
	}
sub permcheckd	# takes directory, owner ID, owner name, and expected permision as args
	{local ($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat($_[0]);
	if ($ui != $_[1]) {print "***** Danger - $_[0] should be owned by user $_[2].\n   Use 'chown $_[2] $_[0]' as root to correct this.\n\n";}
	if (($mode & 0777) != $_[3]) {print "***** Danger - $_[0] should be protected $_[4].\n   Use 'chmod $_[4] $_[0]' to repair this.\n\n";}
	}
sub permchecks	# takes file, assumes system owners
	{local ($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat($_[0]);
	if ($ui > 99) {print "***** Danger - $_[0] should be owned by a system user.\n   Use 'chown' to correct this.\n\n";}
	if ((022 & $mode) != 00) {print "***** Danger - $_[0] should ONLY be writable by its owner.\n   Use 'chmod g-w $_[0]' to repair this.\n\n";}
	}

sub rpermchecks	# takes file, recursive source - assumes system owners
	{local ($dev, $ino, $mode, $nlink, $ui, $gi, $rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)=stat($_[0]);
	if ($ui > 99) {print "+++ Dependency - $_[0] ($_[1]) should be owned by a system user.\n   Use 'chown' to repair this.\n\n";}
	if ((022 & $mode) != 00) {print "+++ Dependency - $_[0] ($_[1]) should only be writable by its owner.\n   Use 'chmod g-w $_[0]' to repair this.\n\n";}
	}

sub stringcheck		# takes pathname and UID - runs strings | grep filename
	# then verifies that this file is properly owned with a permcheck
	{local (@ZZ, $L);
	if (-r $_[0])
		{@ZZ=grep(/^\//,split(/\n/,`$STRINGSPROG $_[0]`));
		foreach $L (@ZZ) {if ((-f "$L") && !(-b "$L") && !(-c "$L"))
			{if ($BIGNORE{"$L"} ne "X")
				{rpermchecks("$L", "$_[0]");
				$BIGNORE{"$L"}="X";		# don't recheck it
				if (-f $L) {stringcheck($L);}	# recursive on files
			}	}
	}	}		}
return true;
