sub wrappers
{print $SECSTART; print "Checking tcp wrappers setup.\n";
@denyall=();
if (!-e $ALLOWFILE) {print "No $ALLOWFILE file - probably not running tcp wrappers.\n";}
else	{@denyall==grep(/all:    all:    deny/,split(/\n/,`$CATPROG $ALLOWFILE`));}
if (-e $DENYFILE)
	{@ZZ=grep(/^[Aa][Ll][Ll]:\s[Aa][Ll][Ll]/,split(/\n/,`$CATPROG $DENYFILE`));
	if ((scalar(@ZZ) == 0) && (scalar(@denyall) != 0))
		{print "******* PROBABLY AN IMPROPER TCP WRAPPERS CONFIGURATION\n";
		print "Add a line starting with 'all:	all' to the end of the\n";
		print "$DENYFILE file. This will make refusing access the default\n";
		print "and only allow access as specified in the $ALLOWFILE file.\n\n";}
	else	{print "'all: all' found in $DENYFILE -OR-\n'all: all: deny' found in $ALLOWFILE\n- it seems appropriate:\n";
		foreach $L (@ZZ) {print "$L\n";}
		print "\n";}}
elsif (-e $ALLOWFILE)
	{print "******* PROBABLY AN IMPROPER TCP WRAPPERS CONFIGURATION\n";
	print "Create a $DENYFILE file containing 'all:	all' as the\n";
	print "only line.  This will make refusing access the default\n";
	print "and only allow access as specified in the $ALLOWFILE file.\n\n";}
else	{print "No $DENYFILE file - you must not be running tcp wrappers.\n\n";}
print $SECEND; print "Done checking tcp wrappers setup.\n\n\n";
}
return true;
